package service;

public abstract class State {
	private String name;
	/** Create a new state
	 * @param name the name that identifies the state
	 */
	public State(String name){
		this.name=name;
	}
	/** Returns if the current state is final or not.
	 * @return returns true if the state is final else return false
	 */
	public abstract boolean  isFinal();
	/** Returns if the current state is a initial state.
	 * @return returns true if the state is a initials state else return false
	 */
	public abstract boolean  isInitial();
	/** Return the name of the state
	 * @return the string contains the name of the state
	 */
	public String getName(){
		return name;
	};
	
	public void setName(String name){
		this.name=name;
	};

	/**
	 * This method returns the hashCode of the state
	 * @return The string contains the hashCode of the state
	 */
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}
	/**
	 * This method compares a state with another object
	 * 
	 * @param obj the other object used by the comparison
	 * @return Return true if and only if obj is a State and the attributes of the two State are equals.
	 */
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		State other = (State) obj;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}
}
